﻿/***************************************************************************
 * File Name: type.h
 * Description: 名称显式体现字节长度的类型定义（默认1字节对齐）
 * Author: [Your Name/Team Name]
 * Date Created: [YYYY-MM-DD]
 * Version: 1.8（VS2022兼容性优化，基于C99标准库）
 ***************************************************************************/

#ifndef _TYPE_H_  // 修正：原宏名_TYP_H_H_重复，改为_TYP_H_避免冲突
#define _TYPE_H_

#include <stdint.h>   // 引入C99标准类型（uint8_t等，解决VS2022类型冲突）
#include <stddef.h>   // 标准库size_t，必须包含以避免与自定义类型冲突

 /* -------------------------- 字节对齐控制宏（保持不变） -------------------------- */
#if defined(__GNUC__) || defined(__ARMCC_VERSION)  // GCC/ARMCC编译器
#define PACKED __attribute__((packed))
#define ALIGNED(x) __attribute__((aligned(x)))
#define BEGIN_PACKED PACKED
#define END_PACKED
#elif defined(_MSC_VER)  // MSVC/VS2022编译器
#define PACKED __pragma(pack(push, 1))
#define PACKED_END __pragma(pop)
#define BEGIN_PACKED PACKED
#define END_PACKED PACKED_END
#define ALIGNED(x) __declspec(align(x))
#else
#define PACKED
#define PACKED_END
#define BEGIN_PACKED
#define END_PACKED
#define ALIGNED(x)
#endif

/* -------------------------- 布尔类型（基于标准库，避免重定义） -------------------------- */
#include <stdbool.h>       // 引入C99标准bool
typedef bool bool8;        // 兼容原有bool8，但基于标准bool实现
#define BOOL8_TRUE    true
#define BOOL8_FALSE   false

/* -------------------------- 无符号整数类型（基于C99标准，彻底解决冲突） -------------------------- */
typedef uint8_t        uint8;        // 1字节（映射标准uint8_t）
typedef uint16_t       uint16;       // 2字节（映射标准uint16_t）
typedef uint32_t       uint32;       // 4字节（映射标准uint32_t，解决VS2022重定义）
typedef uint64_t       uint64;       // 8字节（映射标准uint64_t）

/* -------------------------- 有符号整数类型（基于C99标准） -------------------------- */
typedef int8_t         int8;         // 1字节（映射标准int8_t）
typedef int16_t        int16;        // 2字节（映射标准int16_t）
typedef int32_t        int32;        // 4字节（映射标准int32_t）
typedef int64_t        int64;        // 8字节（映射标准int64_t）

/* -------------------------- 指针相关类型（按平台位数适配） -------------------------- */
#if defined(__LP64__) || defined(_WIN64)  // 64位平台
typedef uint64_t       uintptr;      // 8字节（无符号指针，基于标准类型）
typedef int64_t        intptr;       // 8字节（有符号指针）
#else  // 32位平台
typedef uint32_t       uintptr;      // 4字节（无符号指针）
typedef int32_t        intptr;       // 4字节（有符号指针）
#endif

/* -------------------------- 字符类型（与标准库兼容） -------------------------- */
typedef char           chart8;       // 1字节字符（保持原有定义，与char一致）
typedef unsigned char  uchart8;      // 1字节无符号字符

/* -------------------------- 大小与计数类型（明确与标准库区分） -------------------------- */
typedef uint32_t       sizet32;      // 4字节（基于标准uint32_t）
typedef int32_t        ssizet32;     // 4字节带符号长度
#define STANDARD_SIZE_T size_t       // 明确标注标准库size_t

/* -------------------------- 硬件相关类型（基于标准类型） -------------------------- */
typedef uint8_t        byte;         // 1字节硬件字节
typedef uint16_t       word;         // 2字节硬件字
typedef uint32_t       dword;        // 4字节硬件双字

/* -------------------------- 数组长度计算宏（保持不变） -------------------------- */
#define SIZEOF_TB(x) (sizeof(x) / sizeof((x)[0]))

/* -------------------------- 空指针常量（与C标准一致） -------------------------- */
#ifndef NULL
#define NULL ((void*)0)
#endif

#endif /* _TYPE_H_ */  // 与开头宏名保持一致