﻿/*
 * Copyright (C) 2025 芯祥联科技（XXL Technology）All Rights Reserved.
 * 【XXL授权认证 - 接口实现文件（开源）】
 * 说明：
 * 1. 该文件为接口实现，可完全开源，用户可修改值的来源（如读取配置文件/嵌入式Flash）；
 * 2. 需保证返回值格式：
 *    - 固定字符串：严格16位，以'\0'结尾；
 *    - 授权码：5字节，与固定字符串一一对应。
 */
#include "xxl_lic_interface.h"

// ========== 方式1：静态赋值（简单易用，用户直接修改此处值即可） ==========
// 16位固定字符串（替代原USER_FIXED_VALUE宏，严格16位）
static const char g_fixed_value[] = "zhaixy@xxltech.c";
// 5字节授权码（替代原USER_LICENSE_DATA宏，5个值）
static const uint8_t g_license_data[] = {0x00, 0x55, 0x17, 0x70, 0x5B};
// ========== 方式2：读取配置文件（更安全，推荐商用，注释示例） ==========
/*
// 示例：从配置文件读取固定字符串（需自行实现文件读取逻辑）
static char g_fixed_value[17] = {0};
// 示例：从配置文件读取授权码
static uint8_t g_license_data[5] = {0};

// 初始化函数（用户可在程序启动时调用）
void xxl_lic_init(void) {
    // 读取配置文件中的16位固定字符串
    // read_config("xxl_lic.ini", "USER_FIXED_VALUE", g_fixed_value, 17);
    // 读取配置文件中的5字节授权码
    // read_license_from_config("xxl_lic.ini", "USER_LICENSE_DATA", g_license_data, 5);
}
*/

/**
 * @brief 实现：获取16位固定字符串
 */
const char* xxl_lic_get_fixed_value(void) {
    // 校验长度（避免用户误改长度）
    if (strlen(g_fixed_value) != 16) {
        // 长度错误时返回空（SDK会判定鉴权失败）
        return NULL;
    }
    return g_fixed_value;
}

/**
 * @brief 实现：获取5字节授权码
 */
int xxl_lic_get_license_data(uint8_t* out_license) {
    // 校验输出参数
    if (out_license == NULL) {
        return -1; // 参数非法
    }
    // 拷贝5字节授权码到输出参数
    memcpy(out_license, g_license_data, 5);
    return 0; // 成功
}