﻿/*
 * Copyright (C) 2025 芯祥联科技（XXL Technology）All Rights Reserved.
 * 【XXL授权认证 - 公开接口头文件（开源）】
 * 说明：
 * 1. 该文件为公开接口，函数签名固定，SDK LIB会调用这些函数获取鉴权参数；
 * 2. 函数实现可由用户自定义（如读取配置/Flash/静态赋值），需保证返回值格式合法；
 * 3. 禁止修改函数签名（返回值/参数），否则SDK调用会失败。
 */
#ifndef XXL_LIC_INTERFACE_H
#define XXL_LIC_INTERFACE_H

#include <stdint.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief 【开源接口】获取16位固定字符串（替代原USER_FIXED_VALUE宏）
 * @return char* 指向16位固定字符串的指针（必须以'\0'结尾，长度严格16位）
 * @note 函数实现可开源，用户可自定义返回值来源（静态赋值/读取配置/Flash）
 */
const char* xxl_lic_get_fixed_value(void);

/**
 * @brief 【开源接口】获取5字节授权码（替代原USER_LICENSE_DATA宏）
 * @param out_license 输出参数：指向5字节数组的指针，用于存储授权码
 * @return int 0=成功，非0=失败（需保证数组长度≥5字节）
 * @note 函数实现可开源，用户可自定义返回值来源（静态赋值/读取配置/Flash）
 */
int xxl_lic_get_license_data(uint8_t* out_license);

#ifdef __cplusplus
}
#endif

#endif // XXL_LIC_INTERFACE_H