﻿#ifndef AGENT_TRAP_H
#define AGENT_TRAP_H

#include "type.h"
#include "platform.h"

// 对外接口声明
/**
 * @brief 初始化Trap/Inform模块（需在Agent初始化后调用）
 */
void agent_trap_init(void);

/**
 * @brief 发送SNMPv2c链路中断Trap（linkDown）
 * @param nms_ip NMS服务器IP字符串（如"192.168.1.200"）
 * @return BOOL8_TRUE=成功，BOOL8_FALSE=失败
 */
bool8 agent_send_v2c_link_down_trap(const char *nms_ip);

/**
 * @brief 发送SNMPv2c链路恢复Inform（linkUp）
 * @param nms_ip NMS服务器IP字符串（如"192.168.1.200"）
 * @return BOOL8_TRUE=成功，BOOL8_FALSE=失败
 */
bool8 agent_send_v2c_link_up_inform(const char *nms_ip);
bool8 agent_send_v2c_custom_trap(const char *nms_ip, const char *trap_oid);

// 无参数自动选择NMS的发送接口（新增）
bool8 agent_send_v2c_link_down_trap_auto(void);
bool8 agent_send_v2c_link_up_inform_auto(void);

// 匹配Inform响应（供Agent核心层调用）
bool8 agent_trap_match_inform_resp(uint32 req_id);
void agent_inform_timeout_check(void);


#endif // AGENT_TRAP_H
