﻿/***************************************************************************
 * File Name: type.h
 * Description: 名称显式体现字节长度的类型定义（默认1字节对齐）
 * Author: [Your Name/Team Name]
 * Date Created: [YYYY-MM-DD]
 * Version: 1.6
 ***************************************************************************/

#ifndef _TYPE_H_
#define _TYPE_H_
#include <stdint.h>

/* -------------------------- 字节对齐控制宏 -------------------------- */
#if defined(__GNUC__) || defined(__ARMCC_VERSION)  // GCC/ARMCC编译器
#define PACKED __attribute__((packed))
#define ALIGNED(x) __attribute__((aligned(x)))
#elif defined(_MSC_VER)  // MSVC/VS2017编译器
#define PACKED __pragma(pack(push, 1))
#define PACKED_END __pragma(pop)
#define ALIGNED(x) __declspec(align(x))
#else
#define PACKED
#define PACKED_END
#define ALIGNED(x)
#endif

#define BEGIN_PACKED PACKED
#define END_PACKED PACKED_END

/* -------------------------- 布尔类型 (名称直接体现1字节) -------------------------- */
typedef unsigned char bool8;  // 布尔类型，明确占用1字节 (8位)
#define BOOL8_TRUE    1u      // bool8类型的真值
#define BOOL8_FALSE   0u      // bool8类型的假值

/* -------------------------- 无符号整数类型（跨平台修正） -------------------------- */
//typedef unsigned char       uint8;        // 占用1字节 (8位无符号整数)
//typedef unsigned short      uint16;       // 占用2字节 (16位无符号整数)
//typedef unsigned int        uint32;       // 占用4字节 (32位无符号整数，32/64位平台兼容)
//typedef unsigned long long  uint64;       // 占用8字节 (64位无符号整数，跨编译器兼容)

/* -------------------------- 有符号整数类型（跨平台修正） -------------------------- */
//typedef signed char         int8;         // 占用1字节 (8位有符号整数)
//typedef signed short        int16;        // 占用2字节 (16位有符号整数)
//typedef signed int          int32;        // 占用4字节 (32位有符号整数，32/64位平台兼容)
//typedef long long           int64;        // 占用8字节 (64位有符号整数，跨编译器兼容)
typedef uint8_t  uint8;        // 明确基于标准类型
typedef uint16_t uint16;       // 明确基于标准类型
typedef uint32_t uint32;       // 明确基于标准类型
typedef uint64_t uint64;       // 明确基于标准类型

/* -------------------------- 有符号整数类型（基于标准类型） -------------------------- */
typedef int8_t   int8;         // 明确基于标准类型
typedef int16_t  int16;        // 明确基于标准类型
typedef int32_t  int32;        // 明确基于标准类型
typedef int64_t  int64;        // 明确基于标准类型

/* -------------------------- 指针相关类型（按平台位数适配） -------------------------- */
#if defined(__LP64__) || defined(_WIN64)  // 64位平台（如x86_64服务器）
typedef uint64              uintptr;     // 占用8字节 (无符号指针表示)
typedef int64               intptr;      // 占用8字节 (有符号指针表示)
#else  // 32位平台（如嵌入式设备）
typedef uint32              uintptr;     // 占用4字节 (无符号指针表示)
typedef int32               intptr;      // 占用4字节 (有符号指针表示)
#endif

/* -------------------------- 字符类型 -------------------------- */
typedef char                chart8;      // 占用1字节 (8位字符类型)
typedef unsigned char       uchart8;     // 占用1字节 (8位无符号字符)

/* -------------------------- 大小与计数类型 -------------------------- */
typedef uint32              sizet32;     // 占用4字节 (32位非负大小/长度)
typedef int32               ssizet32;    // 占用4字节 (32位带符号大小/长度)

/* -------------------------- 硬件相关类型 -------------------------- */
typedef uint8               byte;        // 占用1字节 (硬件字节)
typedef uint16              word;        // 占用2字节 (16位硬件字)
typedef uint32              dword;       // 占用4字节 (32位硬件双字)

#define SIZEOF_TB(x) sizeof(x)/sizeof(x[0])

/* -------------------------- 空指针常量 -------------------------- */
#ifndef NULL
#define NULL ((void *)0)
#endif

#endif /* _TYPE_H_ */
