﻿#ifndef USER_MIB_H
#define USER_MIB_H

#include "type.h"
#include "snmp_protocol.h"  // 引入SnmpOid、SnmpVarBind类型
#include "mib_registry.h"   // 引入MibNodeConfig类型

/**
 * @brief 自定义节点类型
 */
typedef enum {
    USER_MIB_TEMP_SENSOR = 0,  // 温度传感器节点
    USER_MIB_LED_CONTROL = 1,  // LED控制节点
    USER_MIB_FAN_SPEED = 2     // 风扇转速节点
} UserMibNode;

/**
 * @brief 初始化用户自定义MIB节点
 * @details 构建OID并注册节点到MIB注册表，需在mib_registry_init后调用
 */
void user_mib_init(void);

/**
 * @brief 获取指定节点的OID
 * @param node 节点类型（UserMibNode）
 * @return OID指针，无效节点返回NULL
 */
const SnmpOid* user_mib_get_oid(UserMibNode node);

/**
 * @brief 模拟硬件状态更新（测试用）
 * @param temp 温度（℃，-40~85）
 * @param led_state LED状态（0=关，1=开）
 * @param fan_pwm 风扇PWM（0~1000）
 * @return 成功返回TRUE，参数无效返回FALSE
 */
bool8 user_mib_simulate_hw(int32 temp, uint8 led_state, uint16 fan_pwm);

#endif // USER_MIB_H
