﻿#ifndef TPS_H
#define TPS_H

#include "type.h"
#include "snmp_protocol.h"

// 回调函数类型定义（用于MIB数据采集通知）
typedef void (*MibCollCallback)(const SnmpOid* oid, const SnmpVarBind* value);

// TPS模块函数声明
/**
 * 配置TPS模块参数
 * @note 实际实现应包含目标协议栈的初始化配置
 */
void tps_cfg_tps(void);

/**
 * 请求采集MIB数据
 * @param[in]  oid   目标MIB对象的OID
 * @param[out] value 存储采集结果的变量绑定结构
 * @return 采集成功返回BOOL8_TRUE，失败或不支持的OID返回BOOL8_FALSE
 */
bool8 tps_mib_coll_req(const SnmpOid* oid, SnmpVarBind* value);

/**
 * 注册MIB数据采集回调函数
 * @param callback 回调函数指针，当MIB数据更新时触发
 */
void tps_mib_coll_callback_reg(MibCollCallback callback);

/**
 * 启动TPS模块
 * @note 启动后开始处理协议栈交互和MIB数据采集
 */
void tps_start(void);

/**
 * 停止TPS模块
 * @note 停止后释放相关资源，不再进行数据采集和协议交互
 */
void tps_stop(void);

#endif  // TPS_H
    
